package ga.core.validation;

import ga.core.individual.IIndividual;

/**
 * Interface for an individual validator.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IValidator<T extends IIndividual<T>> {
  /**
   * Validates an individual.
   * 
   * @param individual
   *          The individual to test for being valid.
   * @param context
   *          The GA context.
   * @return <code>true</code> if the individual is valid, false otherwise.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public boolean isValid(T individual, GAContext context);

}
